// GetAccessTree.cpp : implementation file
//

#include "stdafx.h"
#include "db_apivcclient.h"
#include "GetAccessTree.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGetAccessTree dialog


CGetAccessTree::CGetAccessTree(CWnd* pParent /*=NULL*/)
	: CDialog(CGetAccessTree::IDD, pParent)
{

	//{{AFX_DATA_INIT(CGetAccessTree)
	m_sXML = _T("");
	//}}AFX_DATA_INIT
}

CGetAccessTree ::CGetAccessTree(IApplication *pApp):CDialog(CGetAccessTree::IDD, NULL)
{
	pApplication = pApp;
}


void CGetAccessTree::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CDialog::OnFinalRelease();
}

void CGetAccessTree::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetAccessTree)
	DDX_Control(pDX, IDC_ACCLLIST, m_ALlist);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Text(pDX, IDC_EDIT_XML, m_sXML);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGetAccessTree, CDialog)
	//{{AFX_MSG_MAP(CGetAccessTree)
	ON_CBN_SELCHANGE(IDC_ACCLLIST, OnSelchangeAccllist)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_BN_CLICKED(IDC_BTN_GETAATREE, OnBtnGetAATree)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CGetAccessTree, CDialog)
	//{{AFX_DISPATCH_MAP(CGetAccessTree)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IGetAccessTree to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {445B3C04-EE4B-42D7-9156-31AD4FBE50CD}
static const IID IID_IGetAccessTree =
{ 0x445b3c04, 0xee4b, 0x42d7, { 0x91, 0x56, 0x31, 0xad, 0x4f, 0xbe, 0x50, 0xcd } };

BEGIN_INTERFACE_MAP(CGetAccessTree, CDialog)
	INTERFACE_PART(CGetAccessTree, IID_IGetAccessTree, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetAccessTree message handlers

void CGetAccessTree::OnSelchangeAccllist() 
{
	// TODO: Add your control notification handler code here
	
}

void CGetAccessTree::OnSelchangeAcctlist() 
{
	int index_Acct = m_AcctList.GetCurSel();
	CString test;
	test.Format(_T("Selected Acct ID: %d"),index_Acct);
	OutputDebugString(test);
	CString sAcctid;

	m_AcctList.GetLBText(index_Acct,sAcctid);
	long lAccountID = _wtoi(sAcctid);
OutputDebugString(sAcctid);
	/*m_ALlist.ResetContent();
	LoadAccessLevels();*/

	m_SubAcctList.ResetContent();
	LoadSubAccounts(lAccountID);
}

void CGetAccessTree::OnSelchangeSubAcctlist() 
{
	m_ALlist.ResetContent();
	LoadAccessLevels();
}

void CGetAccessTree::LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctID;
				sAcctID.Format(_T("%ld"),pAccount->AccountID);
				m_AcctList.AddString(sAcctID);
				CString test;
				test.Format(_T("Selected Acct ID: %d"),sAcctID);
				OutputDebugString(test);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}
void CGetAccessTree::LoadSubAccounts(long lAcctID)
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
		pApplication->GetSubAccountsByAccountID(lAcctID,&vSubAccounts); // get subaccount details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pSubAccount = NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount != NULL)
			{
				m_SubAcctList.AddString(pSubAccount->AccountName);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}
void CGetAccessTree ::LoadAccessLevels()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

		//select subaccount name 
		int subacct_index = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(subacct_index,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		_variant_t vAccls;
		vAccls.Clear();
		pApplication->GetAccessLevelsByAccountName(bstrAcctName,bstrSubAcctName,&vAccls); // get access levels details of particular account  in WP-CS database server
		
		if(vAccls.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccessLevel *pAccl = NULL;
		
		COleSafeArray sa(vAccls);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccessLevel,(void**)&pAccl);
			if (pAccl != NULL)
			{
				//m_AcclList.AddString(pAccl->AccessLevelName);
				CString sAcclName;
				sAcclName = CString((LPWSTR)pAccl->AccessLevelName);
				m_ALlist.AddString(sAcclName);
				pAccl->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_ALlist.SetCurSel(0);
}

void CGetAccessTree::OnBtnGetAATree() 
{
	UpdateData(TRUE);

	//select account name 
	int index_Acct = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(index_Acct,sAcctID);
	long lAccountID = _wtol(sAcctID);
	BSTR bstrAcctName;
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

	int index_AL = m_ALlist.GetCurSel();
	CString sALName;
	m_ALlist.GetLBText(index_AL,sALName);
	BSTR bstrALName = sALName.AllocSysString();

	BSTR bstrXML;
	pApplication->GetAccessTreeByName(bstrALName,bstrAcctName, &bstrXML);

	m_sXML = CString((LPWSTR)bstrXML);

	UpdateData(FALSE);
}

BOOL CGetAccessTree::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_AcctList.Clear();
	LoadAccounts();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
